/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DebugShell;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.components.DebugJTableRenderer;
import net.nooj4nlp.gui.components.DebugJTreeRenderer;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DebugShell;

public class DebugShellController {
    public DebugShell debugShell;
    public GrammarEditorShellController grammarController;
    private Language lan;
    public static RefObject<ArrayList<ArrayList<Object>>> solNodesRef;

    public DebugShellController(DebugShell debugShell, GrammarEditorShellController grammarController) {
        this.debugShell = debugShell;
        this.grammarController = grammarController;
        this.lan = null;
    }

    public void comboPressedKeyEvent(KeyEvent e) {
        this.clearAllItems(this.debugShell, true, true);
        if (e.getKeyCode() == 10) {
            this.debug();
        } else {
            this.stopBlinking();
        }
    }

    public void buttonPressedFunction() {
        this.clearAllItems(this.debugShell, true, true);
        this.debug();
    }

    private void debug() {
        this.clearAllItems(this.debugShell, true, false);
        String comboText = this.debugShell.getComboExpression().getSelectedItem().toString();
        ArrayList<Object> aDebug = this.debugLine(comboText);
        if (aDebug != null && aDebug.size() > 1) {
            for (int i = 1; i < aDebug.size(); i += 3) {
                String debugString;
                int lastPosition = 0;
                ArrayList aNodes = (ArrayList)aDebug.get(i);
                ArrayList aInputs = (ArrayList)aDebug.get(i + 1);
                String output = aDebug.get(i + 2) == null ? null : aDebug.get(i + 2).toString();
                StringBuilder sbI = new StringBuilder();
                StringBuilder sbO = new StringBuilder();
                for (int j = 0; j < aNodes.size(); ++j) {
                    if (aNodes.get(j) instanceof String) {
                        sbI.append(" (\"" + aNodes.get(j).toString() + "\" ");
                        continue;
                    }
                    int nodeNb = (Integer)aNodes.get(j);
                    if (nodeNb == 1) {
                        sbI.append(" )");
                        while (j + 1 < aNodes.size() && (Integer)aNodes.get(j + 1) == -1) {
                            ++j;
                        }
                        continue;
                    }
                    if (j >= aInputs.size()) continue;
                    if (aInputs.get(j) instanceof String) {
                        String morpheme = aInputs.get(j).toString();
                        if (morpheme != null && morpheme.length() > 2 && morpheme.charAt(0) == '$' && morpheme.charAt(1) == '(') {
                            sbI.append(morpheme + " ");
                            continue;
                        }
                        if (morpheme == "$)") {
                            sbI.append(" " + morpheme + " ");
                            continue;
                        }
                        sbI.append(morpheme);
                        continue;
                    }
                    int position = ((Double)aInputs.get(j)).intValue();
                    if (position <= lastPosition) continue;
                    while (position > comboText.length()) {
                        --position;
                    }
                    String tok = comboText.substring(lastPosition, position);
                    sbI.append(tok);
                    lastPosition = position;
                }
                if (output != null && !output.equals("")) {
                    sbO.append(output);
                }
                Color colorOfARow = (debugString = aDebug.get(0).toString()).equals("perfect") ? new Color(20, 180, 62) : (debugString.equals("partial") ? Color.BLUE : Color.RED);
                Object[] rowObject = new Object[]{sbI.toString(), sbO.toString(), aNodes.clone()};
                JTable debugTable = this.debugShell.getTableTraces();
                DefaultTableModel tableModel = (DefaultTableModel)debugTable.getModel();
                DebugJTableRenderer renderer = this.debugShell.getCustomTableRenderer();
                renderer.getColoredRowsMap().put(tableModel.getRowCount(), colorOfARow);
                tableModel.addRow(rowObject);
            }
        }
    }

    private ArrayList<Object> debugLine(String currentLine) {
        int iSol;
        boolean applyRes;
        Grammar grammar = this.grammarController.grammar;
        if (grammar == null) {
            return null;
        }
        if (this.lan == null) {
            this.lan = this.grammarController.lan;
        }
        RefObject<Language> lanRef = new RefObject<Language>(this.lan);
        Engine engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        this.lan = (Language)lanRef.argvalue;
        String errorMessage = "";
        RefObject<String> errorMessageRef = new RefObject<String>(errorMessage);
        try {
            if (!engine.loadResources(Launcher.preferences.ldic.get(this.lan.isoName), Launcher.preferences.lsyn.get(this.lan.isoName), true, errorMessageRef)) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessageRef.argvalue, "Warning: Cannot load linguistic resources!", 2);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return null;
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return null;
        }
        errorMessage = grammar.compileAll(engine);
        if (errorMessage != null) {
            Dic.writeLog(errorMessage);
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Error!", 0);
            return null;
        }
        String line = currentLine;
        if (grammar.gramType == GramType.MORPHO) {
            int iSol2;
            Gram grm = grammar.grams.get("Main");
            if (grm == null || grm.states == null || grm.states.size() < 2) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + grammar.fullName + " has no Main graph!", "NooJ: no main graph in grammar", 0);
                return null;
            }
            RefObject<ArrayList<Integer>> solLengthsRef = new RefObject<ArrayList<Integer>>(new ArrayList());
            solNodesRef = new RefObject(new ArrayList());
            RefObject<ArrayList<ArrayList<String>>> solInputsRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
            RefObject<ArrayList<ArrayList<String>>> solOutputsRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
            int da = grammar.morphoMatch("Main", line, grm, solLengthsRef, solInputsRef, solOutputsRef, solNodesRef);
            ArrayList solLengths = (ArrayList)solLengthsRef.argvalue;
            ArrayList solNodes = (ArrayList)DebugShellController.solNodesRef.argvalue;
            ArrayList solInputs = (ArrayList)solInputsRef.argvalue;
            ArrayList solOutputs = (ArrayList)solOutputsRef.argvalue;
            if (da > 0) {
                int iSol3;
                boolean perfectMatch = false;
                int longestMatch = -1;
                ArrayList<Object> res = new ArrayList<Object>();
                for (iSol3 = 0; iSol3 < solLengths.size(); ++iSol3) {
                    int l = (Integer)solLengths.get(iSol3);
                    if (l == line.length()) {
                        perfectMatch = true;
                        continue;
                    }
                    if (l <= longestMatch) continue;
                    longestMatch = l;
                }
                for (iSol3 = 0; iSol3 < solNodes.size(); ++iSol3) {
                    ArrayList aSolTrace;
                    ArrayList aSolNode;
                    if (perfectMatch) {
                        int stL = (Integer)solLengths.get(iSol3);
                        if (stL < line.length()) continue;
                        aSolNode = (ArrayList)solNodes.get(iSol3);
                        aSolTrace = (ArrayList)solInputs.get(iSol3);
                        ArrayList stO = (ArrayList)solOutputs.get(iSol3);
                        StringBuilder oTrace = grammar.processVariablesInOutputs(aSolTrace, stO);
                        if (Grammar.isComplex(oTrace)) {
                            String errorMessage2 = "";
                            RefObject<String> errorMessageRef2 = new RefObject<String>(errorMessage2);
                            ArrayList<ArrayList<String>> cSols = grammar.processConstraints(oTrace.toString(), errorMessageRef2);
                            errorMessage2 = (String)errorMessageRef2.argvalue;
                            if (cSols == null || cSols.size() == 0) {
                                res.add(aSolNode);
                                res.add(aSolTrace);
                                res.add(errorMessage2);
                                continue;
                            }
                            ArrayList<ArrayList<String>> listOfSols = grammar.defactorize(cSols);
                            for (int icSol = 0; icSol < listOfSols.size(); ++icSol) {
                                ArrayList<String> los = listOfSols.get(icSol);
                                StringBuilder resTrace = Grammar.computeInput(los);
                                res.add(aSolNode);
                                res.add(aSolTrace);
                                res.add(resTrace.toString());
                            }
                            continue;
                        }
                        res.add(aSolNode);
                        res.add(aSolTrace);
                        res.add(oTrace.toString());
                        continue;
                    }
                    int stl = (Integer)solLengths.get(iSol3);
                    if (stl < longestMatch) continue;
                    aSolNode = (ArrayList)solNodes.get(iSol3);
                    aSolTrace = (ArrayList)solInputs.get(iSol3);
                    res.add(aSolNode);
                    res.add(aSolTrace);
                    res.add(null);
                }
                if (perfectMatch) {
                    res.add(0, "perfect");
                } else {
                    res.add(0, "partial");
                }
                return res;
            }
            da = grammar.morphoMatch("Main", line, grm, solLengthsRef, solInputsRef, solOutputsRef, solNodesRef);
            solLengths = (ArrayList)solLengthsRef.argvalue;
            solNodes = (ArrayList)DebugShellController.solNodesRef.argvalue;
            solInputs = (ArrayList)solInputsRef.argvalue;
            solOutputs = (ArrayList)solOutputsRef.argvalue;
            int longestMatch = -1;
            ArrayList<Object> res = new ArrayList<Object>();
            for (iSol2 = 0; iSol2 < solNodes.size(); ++iSol2) {
                ArrayList n = (ArrayList)solNodes.get(iSol2);
                int l = n.size();
                if (l <= longestMatch) continue;
                longestMatch = l;
            }
            for (iSol2 = 0; iSol2 < solNodes.size(); ++iSol2) {
                ArrayList aSolNode = (ArrayList)solNodes.get(iSol2);
                if (aSolNode.size() < longestMatch) continue;
                ArrayList aSolTrace = (ArrayList)solInputs.get(iSol2);
                res.add(aSolNode);
                res.add(aSolTrace);
                res.add(null);
            }
            res.add(0, "failure");
            return res;
        }
        Ntext myText = new Ntext(this.lan.isoName);
        myText.buffer = line;
        myText.mft = engine.delimit(myText);
        HashMap<String, ArrayList<String>> simpleWordCache = new HashMap<String, ArrayList<String>>();
        myText.annotations = new ArrayList();
        RefObject<String> errorMessageRef2 = new RefObject<String>(errorMessage);
        if (!engine.tokenize(myText, myText.annotations, simpleWordCache, errorMessageRef2)) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessageRef2.argvalue, "NooJ Tokenizer Error", 0);
            myText.annotations = null;
            myText.hLexemes = null;
            myText.hUnknowns = null;
            return null;
        }
        simpleWordCache = null;
        myText.hPhrases = new HashMap();
        RefObject<String> errorMessageRef3 = new RefObject<String>("");
        if (engine.synGrms != null && engine.synGrms.size() > 0) {
            try {
                applyRes = engine.applyAllGrammars(myText, myText.annotations, 0, errorMessageRef3);
                errorMessage = (String)errorMessageRef3.argvalue;
                if (!applyRes && errorMessage != null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                    return null;
                }
                if (!applyRes) {
                    myText.hPhrases = null;
                    return null;
                }
                myText.cleanupBadAnnotations(myText.annotations);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return null;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
        }
        errorMessageRef3 = new RefObject<String>("");
        if (engine.synGrms != null && engine.synGrms.size() > 0) {
            try {
                applyRes = engine.applyAllGrammars(myText, myText.annotations, 1, errorMessageRef3);
                errorMessage = (String)errorMessageRef3.argvalue;
                if (!applyRes && errorMessage != null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                    return null;
                }
                if (!applyRes) {
                    myText.hPhrases = null;
                    return null;
                }
                myText.cleanupBadAnnotations(myText.annotations);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return null;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
        }
        RefObject<ArrayList<Double>> solLengthsRef = new RefObject<ArrayList<Double>>(new ArrayList());
        RefObject<ArrayList<ArrayList<Object>>> solNodesRef = new RefObject<ArrayList<ArrayList<Object>>>(new ArrayList());
        RefObject<ArrayList<ArrayList<Double>>> solInputsRef = new RefObject<ArrayList<ArrayList<Double>>>(new ArrayList());
        RefObject<ArrayList<ArrayList<String>>> solOutputsRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
        RefObject<ArrayList<ArrayList<String>>> solVariablesRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
        Gram grm = grammar.grams.get("Main");
        if (grm == null || grm.states == null || grm.states.size() < 2) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + grammar.fullName + " has no Main graph!", "NooJ: no main graph in grammar", 0);
            return null;
        }
        ArrayList<String> recursive = new ArrayList<String>();
        int da = grammar.syntaxMatch("Main", 0, line, 0.0, 1, myText.mft, myText.annotations, grm, solLengthsRef, solInputsRef, solVariablesRef, solOutputsRef, solNodesRef, true, recursive);
        ArrayList solLengths = (ArrayList)solLengthsRef.argvalue;
        ArrayList solNodes = (ArrayList)solNodesRef.argvalue;
        ArrayList solVariables = (ArrayList)solVariablesRef.argvalue;
        ArrayList solInputs = (ArrayList)solInputsRef.argvalue;
        ArrayList solOutputs = (ArrayList)solOutputsRef.argvalue;
        if (da > 0) {
            int iSol4;
            boolean partialMatch = true;
            ArrayList<Object> res = new ArrayList<Object>();
            for (iSol4 = 0; iSol4 < solLengths.size(); ++iSol4) {
                double l = (Double)solLengths.get(iSol4);
                if (l != (double)line.length()) continue;
                partialMatch = false;
            }
            for (iSol4 = 0; iSol4 < solNodes.size(); ++iSol4) {
                ArrayList aSolNode = (ArrayList)solNodes.get(iSol4);
                ArrayList relAddresses = (ArrayList)solInputs.get(iSol4);
                ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, myText.mft.tuAddresses[1]);
                int rightMargin = ((Double)solLengths.get(iSol4)).intValue();
                boolean check = true;
                ArrayList resOutputs = null;
                ArrayList resVariables = new ArrayList();
                resVariables.add(new HashMap());
                RefObject<Object> resOutputsRef = new RefObject<Object>(resOutputs);
                RefObject<ArrayList<HashMap<String, String>>> resVariablesRef = new RefObject<ArrayList<HashMap<String, String>>>(resVariables);
                RefObject<String> errMessageRef = new RefObject<String>("");
                if (Dic.isThereALexicalConstraint((ArrayList)solOutputs.get(iSol4))) {
                    try {
                        check = engine.newProcessConstraints(line, myText.mft, myText.annotations, 1, grammar, (ArrayList)solInputs.get(iSol4), rightMargin, (ArrayList)solVariables.get(iSol4), 0.0, (ArrayList)solOutputs.get(iSol4), resOutputsRef, resVariablesRef, 0, errMessageRef);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                        return null;
                    }
                }
                resOutputs = (ArrayList)resOutputsRef.argvalue;
                resVariables = (ArrayList)resVariablesRef.argvalue;
                errorMessage = (String)errMessageRef.argvalue;
                if (!check) {
                    res.add(aSolNode);
                    res.add(absAddresses);
                    ArrayList<Object> seqOfAnnotations = engine.mergeIntoAnnotations(line, 1, 0.0, (Double)solLengths.get(iSol4), absAddresses, (ArrayList)solOutputs.get(iSol4), false);
                    if (seqOfAnnotations != null && seqOfAnnotations.size() > 0) {
                        if (!check) {
                            res.add(errorMessage + ": " + seqOfAnnotations.get(1).toString());
                            continue;
                        }
                        res.add(seqOfAnnotations.get(1).toString());
                        continue;
                    }
                    res.add(null);
                    continue;
                }
                if (resOutputs == null || resOutputs.size() == 0) {
                    res.add(aSolNode);
                    res.add(absAddresses);
                    res.add(null);
                    continue;
                }
                for (ArrayList output2 : resOutputs) {
                    res.add(aSolNode);
                    res.add(absAddresses);
                    ArrayList<Object> seqOfAnnotations = engine.mergeIntoAnnotations(line, 1, 0.0, (Double)solLengths.get(iSol4), absAddresses, output2, false);
                    if (seqOfAnnotations != null && seqOfAnnotations.size() > 0) {
                        res.add(seqOfAnnotations.get(1).toString());
                        continue;
                    }
                    res.add(null);
                }
            }
            if (partialMatch) {
                res.add(0, "partial");
            } else {
                res.add(0, "perfect");
            }
            return res;
        }
        recursive = new ArrayList();
        da = grammar.failureSyntaxMatch("Main", 0, line, 0.0, 1, myText.mft, myText.annotations, grm, solLengthsRef, solInputsRef, solVariablesRef, solOutputsRef, solNodesRef, true, recursive);
        if (da == 0) {
            return null;
        }
        solLengths = (ArrayList)solLengthsRef.argvalue;
        solNodes = (ArrayList)solNodesRef.argvalue;
        solVariables = (ArrayList)solVariablesRef.argvalue;
        solInputs = (ArrayList)solInputsRef.argvalue;
        solOutputs = (ArrayList)solOutputsRef.argvalue;
        ArrayList<Object> res = new ArrayList<Object>();
        double longestLength = 0.0;
        for (iSol = 0; iSol < solNodes.size(); ++iSol) {
            ArrayList relAddresses = (ArrayList)solInputs.get(iSol);
            ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, myText.mft.tuAddresses[1]);
            double len = absAddresses.get(absAddresses.size() - 1);
            if (!(len > longestLength)) continue;
            longestLength = len;
        }
        for (iSol = 0; iSol < solNodes.size(); ++iSol) {
            ArrayList aSolNode = (ArrayList)solNodes.get(iSol);
            ArrayList relAddresses = (ArrayList)solInputs.get(iSol);
            ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, myText.mft.tuAddresses[1]);
            double len = absAddresses.get(absAddresses.size() - 1);
            if (len != longestLength) continue;
            res.add(aSolNode);
            res.add(absAddresses);
            res.add(null);
        }
        res.add(0, "failure");
        return res;
    }

    private void stopBlinking() {
        this.grammarController.getTimerDbg().stop();
        ArrayList<Graph> graphs = this.grammarController.grammar.graphs;
        for (int ig = 0; ig < graphs.size(); ++ig) {
            Graph grf = graphs.get(ig);
            grf.stopDebug();
        }
    }

    private void clearAllItems(DebugShell debugShell, boolean clearTableItems, boolean clearTreeItems) {
        if (clearTableItems) {
            JTable debugTable = debugShell.getTableTraces();
            DebugJTableRenderer renderer = debugShell.getCustomTableRenderer();
            renderer.setColoredRowsMap(new HashMap<Integer, Color>());
            DefaultTableModel tableModel = (DefaultTableModel)debugTable.getModel();
            tableModel.getDataVector().removeAllElements();
            tableModel.fireTableDataChanged();
        }
        if (clearTreeItems) {
            DefaultTreeModel debugTreeModel = (DefaultTreeModel)debugShell.getTreeDebug().getModel();
            ((DefaultMutableTreeNode)debugTreeModel.getRoot()).removeAllChildren();
            debugTreeModel.reload();
        }
    }

    public void tableSelectionChangedFunction() {
        JTable debugTable = this.debugShell.getTableTraces();
        DefaultTableModel tableModel = (DefaultTableModel)debugTable.getModel();
        if (debugTable.getSelectedRowCount() == 0) {
            this.stopBlinking();
            return;
        }
        int iSol = debugTable.getSelectedRows()[0];
        ArrayList nodeTrace = (ArrayList)tableModel.getValueAt(iSol, 2);
        String graphName = nodeTrace.get(0).toString();
        this.parseNodeTrace(graphName, nodeTrace, 1);
        String sTrace = debugTable.getValueAt(iSol, 0).toString();
        this.buildSyntacticTree(sTrace);
        this.grammarController.getTimerDbg().start();
    }

    private void buildSyntacticTree(String sTrace) {
        this.clearAllItems(this.debugShell, false, true);
        JTree treeDebug = this.debugShell.getTreeDebug();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)treeDebug.getModel().getRoot();
        DefaultTreeModel treeModel = (DefaultTreeModel)treeDebug.getModel();
        DefaultMutableTreeNode tn = new DefaultMutableTreeNode("Main");
        DebugJTreeRenderer customRenderer = this.debugShell.getCustomTreeRenderer();
        customRenderer.setBackgroundColor(Color.YELLOW);
        int ic = " (\"Main\" ".length();
        this.visit(sTrace, ic, tn);
        top.add(tn);
        treeModel.reload(top);
        treeDebug.expandPath(treeDebug.getPathForRow(0));
    }

    private int visit(String sTrace, int ic, DefaultMutableTreeNode tn) {
        while (ic < sTrace.length()) {
            DefaultMutableTreeNode tc;
            char character = sTrace.charAt(ic);
            if (character == ' ') {
                ++ic;
                continue;
            }
            if (character == ')') {
                return ic + 1;
            }
            if (character == '(') {
                String tr = sTrace.substring(ic + 2);
                if (tr.length() > 0 && tr.charAt(0) == '\"') {
                    int index = tr.indexOf(34);
                    String fName = tr.substring(0, index);
                    tc = new DefaultMutableTreeNode(fName);
                    tn.add(tc);
                    ic += index + 3;
                    ic = this.visit(sTrace, ic, tc);
                    continue;
                }
                ++ic;
            }
            int j = 0;
            while (ic + j < sTrace.length() && sTrace.charAt(ic + j) != '(' && sTrace.charAt(ic + j) != ')') {
                ++j;
            }
            String name = sTrace.substring(ic, ic + j);
            tc = new DefaultMutableTreeNode(name);
            tn.add(tc);
            ic += j;
        }
        return ic;
    }

    private int parseNodeTrace(String graphName, ArrayList<Object> nodeTrace, int i) {
        ArrayList<Object> blinkingNodes = new ArrayList<Object>();
        while (i < nodeTrace.size()) {
            if (nodeTrace.get(i) instanceof String) {
                String gName = nodeTrace.get(i).toString();
                i = this.parseNodeTrace(gName, nodeTrace, i + 1);
            } else {
                int iNode = (Integer)nodeTrace.get(i);
                if (iNode != -1) {
                    blinkingNodes.add(iNode);
                    if (iNode == 1) break;
                }
            }
            ++i;
        }
        Graph grf = null;
        ArrayList<Graph> graphs = this.grammarController.grammar.graphs;
        for (int ig = 0; ig < graphs.size(); ++ig) {
            Graph grf0 = graphs.get(ig);
            if (!grf0.name.equals(graphName)) continue;
            grf = grf0;
            break;
        }
        if (grf != null) {
            grf.setDebug(blinkingNodes);
        }
        return i;
    }
}

